/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	PlaneOfObject.cpp

#include <stdafx.h>

#include "cUtility.h"
#include "CWorkplane.h"
#include "cApplication.h"


HRESULT PlaneOfObject(ITopology *pFirstTopology, CString workplaneName, CString sketchName, VARIANT_BOOL bNoSketch, long color, IWorkplane **retDispatch)
{
	START_METHOD("PlaneOfObject")

	HRESULT status = CONV_SUCCESS;

	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument *activePart = NULL;
	IWorkplane *activeWorkplane = NULL;
	IWorkplane *currentWorkplane = NULL;
	
	ISketch *sketch = NULL;
	ISketch *activeSketch = NULL;
	IObject *object1 = NULL;

	IWorkplane *pPlaneOfObject= NULL;
	IDesign *pDesign= NULL;
	
	IColor *pNewColor= NULL;
	ISketch *pNewSketch = NULL;

	VARIANT_BOOL blnFirstTopology;

	//check if the selected entity belongs to a TopologyClass
	CHECK_VAR_STATUS(pFirstTopology)
	object1 = CAST(IObject, pFirstTopology);

	status = object1->IsA(GetBSTR("Topology"), &blnFirstTopology);
	CHECK_RETURN_STATUS(status)

	if (blnFirstTopology) {
		status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
		CHECK_RETURN_STATUS(status)

		status = activePart->GetDesign(&pDesign);

		IGeometric *firstTopology= NULL;
		IGeometry *pGeom1 = NULL;

		firstTopology = CAST(IGeometric, pFirstTopology);

		status = firstTopology->GetGeometricForm(&pGeom1);
		CHECK_RETURN_STATUS(status)

		// Create the Plane of Object using the zPlane and workplane name
		status = pDesign->CreateWorkplane(CAST(IPlane,pGeom1), workplaneName.AllocSysString(),&pPlaneOfObject);
	
		// Create a sketch with the given sketch name
		if(!bNoSketch)
		{
			status = pPlaneOfObject->CreateSketch(sketchName.AllocSysString(),&pNewSketch);
			CHECK_RETURN_STATUS(status)

			status = activeGraphicDoc->SetActiveSketch(pNewSketch);
			CHECK_RETURN_STATUS(status)

			// Set the color for the sketch
			if(color<0 || color > 11)
				color = 4;

			status = (GetCLASS(Color))->CreateColor(1, color * 30, 0.35, 1, &pNewColor);
			CHECK_RETURN_STATUS(status)

			status = pNewSketch->SetColor(pNewColor);
			CHECK_RETURN_STATUS(status)
		}
	}
	else {
		AfxMessageBox ("Improper Selection of Entities");
		pPlaneOfObject = NULL;
	}

	*retDispatch = pPlaneOfObject;
    END_METHOD("PlaneOfObject")
}
